
// DemoVCDlg.cpp : implementation file
//

#include "pch.h"
#include "framework.h"
#include "DemoVC.h"
#include "DemoVCDlg.h"
#include "afxdialogex.h"

#include <Shlwapi.h>
#pragma comment(lib, "Shlwapi.lib")

#include <Shellapi.h>
#pragma comment(lib, "Shell32.lib")

#include "../../include/ScnLib.h"
#ifdef _WIN64
#pragma comment(lib, "../../lib/Visual C++/x64/ScnLib.lib")
#else
#pragma comment(lib, "../../lib/Visual C++/x86/ScnLib.lib")
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CDemoVCDlg dialog



CDemoVCDlg::CDemoVCDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_DEMOVC_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_timerREC = 0;
	m_timerFPS = 0;
	m_hdcFPS = NULL;
	m_hbmFPS = NULL;
	m_pbmFPS = NULL;
}

void CDemoVCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CDemoVCDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
    ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_START_STOP, &CDemoVCDlg::OnClickedButtonStartStop)
	ON_BN_CLICKED(IDC_BUTTON_PAUSE_RESUME, &CDemoVCDlg::OnClickedButtonPauseResume)
	ON_BN_CLICKED(IDC_BUTTON_MORE_SETTINGS, &CDemoVCDlg::OnClickedButtonMoreSettings)
	ON_BN_CLICKED(IDC_BUTTON_CHANGE_VIDEO_PATH, &CDemoVCDlg::OnClickedButtonChangeVideoPath)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE_VIDEO_PATH, &CDemoVCDlg::OnClickedButtonBrowseVideoPath)
	ON_COMMAND(IDC_RADIO_FULL_SCREEN, &CDemoVCDlg::OnRadioFullScreen)
	ON_COMMAND(IDC_RADIO_A_REGION_WINDOW, &CDemoVCDlg::OnRadioARegionWindow)
	ON_COMMAND(IDC_RADIO_PC_GAME_SCREEN, &CDemoVCDlg::OnRadioPcGameScreen)
	ON_BN_CLICKED(IDC_CHECK_PLAYBACK_AUDIO, &CDemoVCDlg::OnClickedCheckPlaybackAudio)
	ON_BN_CLICKED(IDC_CHECK_MICROPHONE_AUDIO, &CDemoVCDlg::OnClickedCheckMicrophoneAudio)
	ON_BN_CLICKED(IDC_CHECK_WEBCAM_PREVIEW, &CDemoVCDlg::OnClickedCheckWebcamPreview)
	ON_BN_CLICKED(IDC_CHECK_WEBCAM_OVERLAY, &CDemoVCDlg::OnClickedCheckWebcamOverlay)
	ON_BN_CLICKED(IDC_CHECK_FULL_WEBCAM_VIDEO, &CDemoVCDlg::OnClickedCheckFullWebcamVideo)
END_MESSAGE_MAP()


// CDemoVCDlg message handlers

BOOL CDemoVCDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	TCHAR	logPath[MAX_PATH] = {};

	// Make the log file path the same as the process exe file path but different extension.
	GetModuleFileName(NULL, logPath, MAX_PATH);
	PathRenameExtension(logPath, _T(".txt"));

	// Create a log file that is helpful for debugging.
	// It can be called before calling ScnLib_Initialize().
	ScnLib_SetLogPathW(logPath, TRUE);

	// Initialize the SDK.
	// It must be called before calling most of the other APIs of the SDK.
	// Usually it's called only once at the start of the program.
	ScnLib_InitializeW(NULL);

	// Make the screen capture region frame visible. It's invisible by default.
	// If you don't like the style of the SDK built-in screen capture region frame, you may implement your own.
	ScnLib_ShowCaptureRegionFrame(TRUE);

	// We prefer 1080p webcam resolution. It's 320x240 by default.
	// If your webcam doesn't support the resolution you set, the SDK will choose the closest resolution automatically.
	ScnLib_SetWebcamResolution(1920, 1080);

	// Default mode: Capture Full Screen
	CheckDlgButton(IDC_RADIO_FULL_SCREEN, BST_CHECKED);

	// Change the font of the REC time text
	static CFont font;
	static LOGFONT lf;

	GetDlgItem(IDC_STATIC_REC_TIME)->GetFont()->GetLogFont(&lf);
	lf.lfHeight = static_cast<long>(lf.lfHeight * 1.5);
	StrCpy(lf.lfFaceName, _T("Impact"));
	font.CreateFontIndirect(&lf);
	GetDlgItem(IDC_STATIC_REC_TIME)->SetFont(&font);

	// Initialize the game FPS DIB resource.
	Init_Game_FPS_Overlay();

	// Setup a timer to update the game FPS overlay for game capture mode
	m_timerFPS = SetTimer(2, 1000, NULL);

	Update_UI();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDemoVCDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemoVCDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDemoVCDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CDemoVCDlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	// Kill timers
	if (m_timerREC) KillTimer(m_timerREC);
	if (m_timerFPS) KillTimer(m_timerFPS);

	// Release the game FPS DIB resource.
	Free_Game_FPS_Overlay();

	// Uninitialize the SDK.
	// It must be called before exiting the process or there might be resource leak.
	// Usually it's called only once at the end of the program.
	ScnLib_Uninitialize();
}


void CDemoVCDlg::OnTimer(UINT_PTR nIDEvent)
{
	if (nIDEvent == m_timerREC)
	{
		// Since the SDK doesn't have any callback mechanism, 
		// you need to check the recording status periodically in a timer.
		// If it's recording then update the recording time info.
		if (ScnLib_IsRecording())
		{
			TCHAR	szRecTime[11];

			// Get the current recording time string in the format of 'HH:MM:SS'.
			ScnLib_GetRecTimeW(szRecTime);

			SetDlgItemText(IDC_STATIC_REC_TIME, szRecTime);
		}
		// If it's not recording then stop recording on failure.
		// The recording may stop automatically if a fatal error occurs.
		// In this case you still need to do some cleanup and UI updates.
		else
		{
			Stop_Recording(FALSE);

			Update_UI();
		}
	}
	else if (nIDEvent == m_timerFPS)
	{
		// Is currently game capture mode and a Direct3D/OpenGL game window detected?
		if (ScnLib_GetGameWnd())
		{
			// Update the game FPS overlay.
			Update_Game_FPS_Overlay();
		}
	}

    CDialogEx::OnTimer(nIDEvent);
}


void CDemoVCDlg::Init_Game_FPS_Overlay(void)
{
	// FPS: Frames Per Second
	// DIB: Device-Independent Bitmap
	// Create a screen compatible DC for the game FPS DIB first.
	m_hdcFPS = CreateCompatibleDC(NULL);

	if (m_hdcFPS)
	{
		// Fill the BITMAPINFO structure.
		ZeroMemory(&m_bmiFPS, sizeof(m_bmiFPS));
		m_bmiFPS.bmiHeader.biSize = sizeof(m_bmiFPS.bmiHeader);
		m_bmiFPS.bmiHeader.biWidth = 170;
		m_bmiFPS.bmiHeader.biHeight = -70; // A negative value indicates a top-down DIB.
		m_bmiFPS.bmiHeader.biPlanes = 1;
		m_bmiFPS.bmiHeader.biBitCount = 24;
		m_bmiFPS.bmiHeader.biCompression = BI_RGB;

		// Create the game FPS DIB and get the DIB bit buffer pointer.
		m_hbmFPS = CreateDIBSection(m_hdcFPS, &m_bmiFPS, 0, &m_pbmFPS, NULL, 0);
	}
}


void CDemoVCDlg::Free_Game_FPS_Overlay(void)
{
	if (m_hbmFPS)
	{
		DeleteObject(m_hbmFPS);
		m_hbmFPS = NULL;
	}

	if (m_hdcFPS)
	{
		DeleteObject(m_hdcFPS);
		m_hdcFPS = NULL;
	}
}


void CDemoVCDlg::Update_Game_FPS_Overlay(void)
{
	// Check the game FPS DIB resource handles.
	if (!m_hdcFPS || !m_hbmFPS || !m_pbmFPS) return;

	// The game FPS DIB dimension and pixel bit count.
	int w = m_bmiFPS.bmiHeader.biWidth;
	int h = -m_bmiFPS.bmiHeader.biHeight;
	int bitcount = m_bmiFPS.bmiHeader.biBitCount;

	// Create the fonts for drawing the game FPS and REC time.
	static CFont fontFPS;
	static CFont fontTime;

	if (!fontFPS.GetSafeHandle())
	{
		LOGFONT lf;
		ZeroMemory(&lf, sizeof(lf));
		lf.lfHeight = -30;
		StrCpy(lf.lfFaceName, _T("Impact"));
		fontFPS.CreateFontIndirect(&lf);
	}

	if (!fontTime.GetSafeHandle())
	{
		LOGFONT lf;
		ZeroMemory(&lf, sizeof(lf));
		lf.lfHeight = -25;
		StrCpy(lf.lfFaceName, _T("Impact"));
		fontTime.CreateFontIndirect(&lf);
	}

	// Select the game FPS DIB into the DC for drawing.
	HBITMAP	hbmOld = (HBITMAP)SelectObject(m_hdcFPS, m_hbmFPS);
	// Select the font into the DC for drawing game FPS.
	HFONT	hftOld = (HFONT)SelectObject(m_hdcFPS, fontFPS.GetSafeHandle());
	CRect	rc(0, 0, w, h);
	CString strFPS;

	// Get the game FPS number.
	strFPS.Format(_T("%d fps"), ScnLib_GetGameFrameRate());

	TCHAR	szRecTime[11];

	// Get the current recording time string in the format of 'HH:MM:SS'.
	ScnLib_GetRecTimeW(szRecTime);

	// Clear the overlay background.
	FillRect(m_hdcFPS, rc, (HBRUSH)GetStockObject(WHITE_BRUSH));

	// Shrink the drawing area
	rc.DeflateRect(3, 3);

	// Display a camera icon on the left side.
	DrawIconEx(m_hdcFPS, rc.left, rc.top, m_hIcon, rc.Height(), rc.Height(), 0, NULL, DI_NORMAL);

	// Draw the game FPS number.
	SetTextColor(m_hdcFPS, RGB(128, 128, 128));
	DrawText(m_hdcFPS, strFPS, -1, rc, DT_RIGHT | DT_TOP | DT_SINGLELINE);

	// Draw the REC time.
	SelectObject(m_hdcFPS, fontTime.GetSafeHandle());
	SetTextColor(m_hdcFPS, ScnLib_IsRecording() ? RGB(255, 0, 0) : RGB(0, 200, 0));
	DrawText(m_hdcFPS, szRecTime, -1, rc, DT_RIGHT | DT_BOTTOM | DT_SINGLELINE);

	// Restore the old object handles
	SelectObject(m_hdcFPS, hbmOld);
	SelectObject(m_hdcFPS, hftOld);

	// Show the game FPS overlay on the top-right corner of the game screen.
	ScnLib_SetInGameOverlayPosition(SCNLIB_POSITION_TOP_RIGHT, 5, 5);
	ScnLib_ShowInGameOverlay(m_pbmFPS, w, h, bitcount);
}


void CDemoVCDlg::Update_UI(void)
{
	// Update the radio boxes in the Screen Capture group.
	GetDlgItem(IDC_RADIO_FULL_SCREEN)->EnableWindow(!ScnLib_IsRecording());
	GetDlgItem(IDC_RADIO_A_REGION_WINDOW)->EnableWindow(!ScnLib_IsRecording());
	GetDlgItem(IDC_RADIO_PC_GAME_SCREEN)->EnableWindow(!ScnLib_IsRecording());

	// Update the check boxes in the Audio Capture group.
	CheckDlgButton(IDC_CHECK_PLAYBACK_AUDIO, ScnLib_IsRecordAudioSource(TRUE) ? BST_CHECKED : BST_UNCHECKED); // TRUE - the playback audio source (speakers / headphone)
	CheckDlgButton(IDC_CHECK_MICROPHONE_AUDIO, ScnLib_IsRecordAudioSource(FALSE) ? BST_CHECKED : BST_UNCHECKED); // FALSE - the recording audio source (microphone / line-in)

	// Update the check boxes in the Webcam Capture group
	// The webcam capture is enabled only when a webcam device is selected.
	// The selected webcam device index is a zero-based number. The first webcam device index is 0.
	if (ScnLib_GetSelectedWebcamDevice() >= 0)
	{
		GetDlgItem(IDC_CHECK_WEBCAM_PREVIEW)->EnableWindow(TRUE);

		// If the webcam is being previewed you can get a non-zero preview window handle.
		if (ScnLib_GetWebcamPreviewWnd() != NULL)
		{
			CheckDlgButton(IDC_CHECK_WEBCAM_PREVIEW, BST_CHECKED);
		}
		// Otherwise the webcam is not being previewed.
		else
		{
			CheckDlgButton(IDC_CHECK_WEBCAM_PREVIEW, BST_UNCHECKED);
		}

		// If it's set to record webcam only, screen capture will be discarded and you will get a full webcam video.
		if (ScnLib_IsRecordWebcamOnly())
		{
			CheckDlgButton(IDC_CHECK_WEBCAM_OVERLAY, BST_UNCHECKED);
			CheckDlgButton(IDC_CHECK_FULL_WEBCAM_VIDEO, BST_CHECKED);
		}
		// Otherwise you will get a screen recording video with a webcam overlay on it.
		else
		{
			CheckDlgButton(IDC_CHECK_WEBCAM_OVERLAY, BST_CHECKED);
			CheckDlgButton(IDC_CHECK_FULL_WEBCAM_VIDEO, BST_UNCHECKED);
		}
	}
	// A negative index means no webcam device is selected.
	else
	{
		GetDlgItem(IDC_CHECK_WEBCAM_PREVIEW)->EnableWindow(FALSE);
		CheckDlgButton(IDC_CHECK_WEBCAM_PREVIEW, BST_UNCHECKED);
		CheckDlgButton(IDC_CHECK_WEBCAM_OVERLAY, BST_UNCHECKED);
		CheckDlgButton(IDC_CHECK_FULL_WEBCAM_VIDEO, BST_UNCHECKED);
	}

	// Update the elements in the Output Video group.
	TCHAR videoPath[MAX_PATH] = {};

	// Get the output video file path to be created.
	ScnLib_GetVideoPathW(videoPath, FALSE);

	SetDlgItemText(IDC_EDIT_VIDEO_PATH, videoPath);
	GetDlgItem(IDC_EDIT_VIDEO_PATH)->EnableWindow(!ScnLib_IsRecording());
	GetDlgItem(IDC_BUTTON_CHANGE_VIDEO_PATH)->EnableWindow(!ScnLib_IsRecording());

	// Update the recording control buttons at the bottom.
	if (ScnLib_IsRecording())
	{
		SetDlgItemText(IDC_BUTTON_START_STOP, _T("Stop"));
	}
	else
	{
		SetDlgItemText(IDC_BUTTON_START_STOP, _T("Start"));
	}

	if (ScnLib_IsPaused())
	{
		SetDlgItemText(IDC_BUTTON_PAUSE_RESUME, _T("Resume"));
	}
	else
	{
		SetDlgItemText(IDC_BUTTON_PAUSE_RESUME, _T("Pause"));
	}

	GetDlgItem(IDC_BUTTON_PAUSE_RESUME)->EnableWindow(ScnLib_IsRecording());
}


void CDemoVCDlg::Start_Recording(void)
{
	// If no foreground Direct3D/OpenGL game window is detected, prompt user what to do.
	if (ScnLib_IsGameCaptureModeEnabled() && !ScnLib_GetGameWnd())
	{
		AfxMessageBox(_T("\
No foreground Direct3D/OpenGL game window is detected!\n\n\
Please open a Direct3D/OpenGL game and place its window in the foreground, \
or the SDK will automatically fallback to standard screen capture mode."), 
			MB_ICONINFORMATION | MB_OK);
	}

	CString	videoPath;

	GetDlgItemText(IDC_EDIT_VIDEO_PATH, videoPath);

	// Set the output video file path to be created.
	// The file path can include SDK-defined variables: <num>, <date> and <time>
	ScnLib_SetVideoPathW(videoPath);

	// Start recording now.
	if (ScnLib_StartRecording())
	{
		// Start the timer to check the recording status and update recording time.
		m_timerREC = SetTimer(1, 500, NULL);
	}
	else
	{
		// Do some cleanup if recording failed to start.
		Stop_Recording(FALSE);
	}
}


void CDemoVCDlg::Stop_Recording(BOOL bSuccessful)
{
	// Stop the timer
	if (m_timerREC)
	{
		KillTimer(m_timerREC);
		m_timerREC = 0;
	}

	// Stop the recording. It's OK to call it even if no recording is in progress.
	ScnLib_StopRecording();

	TCHAR filePath[MAX_PATH] = {};

	if (bSuccessful)
	{
		// Get the saved video file path if the recording is done successfully.
		ScnLib_GetVideoPathW(filePath, TRUE);
	}
	else
	{
		// Get the saved log file path if the recording is failed.
		ScnLib_GetLogPathW(filePath);
	}

	// Play the video file or show the log file.
	if (PathFileExists(filePath))
	{
		ShellExecute(GetSafeHwnd(), _T("open"), filePath, NULL, NULL, SW_SHOWNORMAL);
	}
}

void CDemoVCDlg::OnClickedButtonStartStop()
{
	if (!ScnLib_IsRecording())
	{
		// Start recording if no recording is in progress.
		Start_Recording();
	}
	else
	{
		// Stop recording if a recording is in progress.
		Stop_Recording(TRUE);
	}

	Update_UI();
}


void CDemoVCDlg::OnClickedButtonPauseResume()
{
	if (!ScnLib_IsPaused())
	{
		// Pause recording if the recording is not paused.
		ScnLib_PauseRecording();
	}
	else
	{
		// Resume recording if the recording is paused.
		ScnLib_ResumeRecording();
	}

	Update_UI();
}


void CDemoVCDlg::OnClickedButtonMoreSettings()
{
	// Popup the SDK built-in settings dialog to let user configure more settings.
	// If you don't like the style of the SDK built-in settings dialog, you may implement your own.
	ScnLib_ConfigureSettings(GetSafeHwnd());

	Update_UI();
}


void CDemoVCDlg::OnClickedButtonChangeVideoPath()
{
	TCHAR videoPath[MAX_PATH] = {};
	OPENFILENAME ofn = {};

	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = GetSafeHwnd();
	// Supported video file formats are MP4, FLV and AVI.
	ofn.lpstrFilter = _T("MP4 videos (*.mp4)\0*.mp4\0FLV videos (*.flv)\0*.flv\0AVI videos (*.avi)\0*.avi\0");
	ofn.lpstrDefExt = _T("mp4");
	ofn.lpstrFile = videoPath;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_OVERWRITEPROMPT;
	ofn.lpstrTitle = _T("Set Output Video File Path");

	// Popup a save file dialog to let user change the output video file path.
	if (GetSaveFileName(&ofn))
	{
		// Set the output video file path to be created.
		ScnLib_SetVideoPathW(ofn.lpstrFile);

		Update_UI();
	}
}


void CDemoVCDlg::OnClickedButtonBrowseVideoPath()
{
	TCHAR videoPath[MAX_PATH] = {};

	// Get the output video file path to be created.
	ScnLib_GetVideoPathW(videoPath, FALSE);

	CString filePath = videoPath;

	// Remove the invalid file path chars that are used by SDK-defined variables: <num>, <date> and <time>
	filePath.Remove(_T('<'));
	filePath.Remove(_T('>'));

	// Get the folder where your recording videos are saved.
	StrCpy(videoPath, filePath);
	PathRemoveFileSpec(videoPath);

	if (PathIsDirectory(videoPath))
	{
		// Browse the video folder in the Windows File Explorer.
		ShellExecute(GetSafeHwnd(), NULL, _T("explorer.exe"), videoPath, NULL, SW_SHOWNORMAL);
	}
}


void CDemoVCDlg::OnRadioFullScreen()
{
	// Don't bind any capture window.
	ScnLib_SetCaptureWnd(NULL, FALSE);
	// Set all-zero coordinates to let SDK detect and use the full screen coordinates.
	ScnLib_SetCaptureRegion(0, 0, 0, 0);
	// Make sure the game capture mode is disabled.
	ScnLib_EnableGameCaptureMode(FALSE);
}


void CDemoVCDlg::OnRadioARegionWindow()
{
	long l = 0, t = 0, r = 0, b = 0;
	HWND hwnd = NULL;

	// Turn mouse cursor into a crosshair and let user select a region/window on screen.
	// To select a region:
	//   1) Move the mouse cursor to the top-left corner of the region you want to capture.
	//   2) Press and hold the left mouse button, and then move the mouse cursor to the bottom-right corner of the region you want to capture.
	//   3) Release the left mouse button, done. Or, you can click the right mouse button to cancel in the middle of the process.
	// To select a window:
	//   1) Move the mouse cursor over the window you want to capture and then the window will be highlighted.
	//   2) Click the left mouse button to select the pointing window.
	// To cancel selection, click the right mouse button.
	// If a region is selected, you will get the region coordinates and a zero window handle.
	// If a window is selected, you will get the window coordinates and a non-zero window handle.
	if (ScnLib_SelectCaptureRegionW(&l, &t, &r, &b, &hwnd, NULL))
	{
		// Bind the capture window if hwnd is non-zero.
		// Or unbind the capture window if hwnd is zero.
		ScnLib_SetCaptureWnd(hwnd, TRUE);
		// Set the capture region coordinates.
		ScnLib_SetCaptureRegion(l, t, r, b);
	}

	// Make sure the game capture mode is disabled.
	ScnLib_EnableGameCaptureMode(FALSE);
}


void CDemoVCDlg::OnRadioPcGameScreen()
{
	// Don't bind any capture window. (You can bind a specific game window if you don't want SDK to detect foreground game window automatically)
	ScnLib_SetCaptureWnd(NULL, FALSE);
	// Set all-zero coordinates to let SDK detect and use the full screen coordinates if no game screen is detected.
	ScnLib_SetCaptureRegion(0, 0, 0, 0);
	// Enable the game capture mode.
	ScnLib_EnableGameCaptureMode(TRUE);
}


void CDemoVCDlg::OnClickedCheckPlaybackAudio()
{
	// Enable/Disable capture from the playback audio source (speakers / headphone).
	ScnLib_RecordAudioSource(TRUE, IsDlgButtonChecked(IDC_CHECK_PLAYBACK_AUDIO) == BST_CHECKED);
}


void CDemoVCDlg::OnClickedCheckMicrophoneAudio()
{
	// Enable/Disable capture from the recording audio source (microphone / line-in).
	ScnLib_RecordAudioSource(FALSE, IsDlgButtonChecked(IDC_CHECK_MICROPHONE_AUDIO) == BST_CHECKED);
}


void CDemoVCDlg::OnClickedCheckWebcamPreview()
{
	// Open/Close the webcam preview window.
	ScnLib_PreviewWebcam(IsDlgButtonChecked(IDC_CHECK_WEBCAM_PREVIEW) == BST_CHECKED, NULL, TRUE, 0);
}


void CDemoVCDlg::OnClickedCheckWebcamOverlay()
{
	if (IsDlgButtonChecked(IDC_CHECK_WEBCAM_OVERLAY) == BST_CHECKED)
	{
		// Enable webcam capture by selecting the first webcam device.
		ScnLib_SelectWebcamDevice(0);
		// Don't record webcam only. Put the webcam overlay on the screen capture video.
		ScnLib_RecordWebcamOnly(FALSE);
	}
	else if (IsDlgButtonChecked(IDC_CHECK_FULL_WEBCAM_VIDEO) == BST_UNCHECKED)
	{
		// Close the webcam preview window.
		ScnLib_PreviewWebcam(FALSE, NULL, TRUE, 0);
		// Disable webcam capture by selecting a negative index.
		ScnLib_SelectWebcamDevice(-1);
	}

	Update_UI();
}


void CDemoVCDlg::OnClickedCheckFullWebcamVideo()
{
	if (IsDlgButtonChecked(IDC_CHECK_FULL_WEBCAM_VIDEO) == BST_CHECKED)
	{
		// Enable webcam capture by selecting the first webcam device.
		ScnLib_SelectWebcamDevice(0);
		// Record webcam only. Discard screen capture. Make a full webcam video.
		ScnLib_RecordWebcamOnly(TRUE);
	}
	else if (IsDlgButtonChecked(IDC_CHECK_WEBCAM_OVERLAY) == BST_UNCHECKED)
	{
		// Close the webcam preview window.
		ScnLib_PreviewWebcam(FALSE, NULL, TRUE, 0);
		// Disable webcam capture by selecting a negative index.
		ScnLib_SelectWebcamDevice(-1);
	}

	Update_UI();
}
